import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_icons.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/home/home_controller.dart';
import 'package:viserpay_agent/view/components/image/custom_svg_picture.dart';

import '../../../../components/buttons/circle_animated_button_with_text.dart';

class WithdrawSection extends StatelessWidget {
  const WithdrawSection({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(
      builder: (controller) => Container(
        width: MediaQuery.of(context).size.width,
        padding: const EdgeInsets.symmetric(vertical: Dimensions.space15, horizontal: Dimensions.space15),
        decoration: BoxDecoration(color: MyColor.getCardBgColor()),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              controller.isAddMoneyModuleEnable && controller.isWithdrawModuleEnable ? MyStrings.addMoneyWithdraw.tr : MyStrings.summary.tr,
              style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w500),
            ),
            Visibility(
                visible: controller.isAddMoneyModuleEnable,
                child: Column(
                  children: [
                    const SizedBox(height: Dimensions.space15),
                    GestureDetector(
                      onTap: () {
                        Get.toNamed(RouteHelper.addMoneyHistoryScreen);
                      },
                      child: Container(
                        width: MediaQuery.of(context).size.width,
                        padding: const EdgeInsets.symmetric(vertical: Dimensions.space10, horizontal: Dimensions.space12),
                        decoration: BoxDecoration(color: MyColor.getCardBgColor(), borderRadius: BorderRadius.circular(Dimensions.defaultRadius), border: Border.all(color: MyColor.colorGrey.withOpacity(0.2), width: 0.5)),
                        child: Row(
                          children: [
                            CircleAnimatedButtonWithText(
                              height: 45,
                              width: 45,
                              isShowText: false,
                              buttonName: MyStrings.transaction,
                              backgroundColor: MyColor.primaryColor.withOpacity(0.1),
                              child: const CustomSvgPicture(image: MyIcons.arrowDawn),
                              onTap: () {},
                            ),
                            const SizedBox(
                              width: Dimensions.space20,
                            ),
                            Expanded(
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      Text(
                                        MyStrings.totalAddMoney.tr,
                                        style: regularDefault.copyWith(color: MyColor.colorBlack.withOpacity(0.5), fontWeight: FontWeight.w500),
                                      ),
                                      Container(
                                        padding: const EdgeInsets.all(Dimensions.space8),
                                        alignment: Alignment.center,
                                        decoration: const BoxDecoration(color: MyColor.screenBgColor, shape: BoxShape.circle),
                                        child: const Icon(Icons.arrow_forward_rounded, color: MyColor.colorBlack, size: 15),
                                      )
                                    ],
                                  ),
                                  //  const SizedBox(height: Dimensions.space8),
                                  Flexible(
                                    flex: 0,
                                    child: Text(
                                      controller.totalAddMoney,
                                      style: regularMediumLarge.copyWith(fontWeight: FontWeight.w600),
                                      overflow: TextOverflow.ellipsis,
                                      maxLines: 2,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                )),
            Visibility(
                visible: controller.isWithdrawModuleEnable,
                child: Column(
                  children: [
                    SizedBox(height: controller.isAddMoneyModuleEnable ? Dimensions.space15 : 0),
                    GestureDetector(
                      onTap: () {
                        Get.toNamed(RouteHelper.withdrawHistoryScreen);
                      },
                      child: Container(
                        width: MediaQuery.of(context).size.width,
                        padding: const EdgeInsets.symmetric(vertical: Dimensions.space10, horizontal: Dimensions.space12),
                        decoration: BoxDecoration(color: MyColor.getCardBgColor(), borderRadius: BorderRadius.circular(Dimensions.defaultRadius), border: Border.all(color: MyColor.colorGrey.withOpacity(0.2), width: 0.5)),
                        child: Row(
                          children: [
                            CircleAnimatedButtonWithText(
                              height: 45,
                              width: 45,
                              isShowText: false,
                              buttonName: MyStrings.transaction,
                              backgroundColor: MyColor.primaryColor.withOpacity(0.1),
                              child: const CustomSvgPicture(image: MyIcons.arrowUp),
                              onTap: () {},
                            ),

                            const SizedBox(
                              width: Dimensions.space20,
                            ),
                            Expanded(
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      Text(
                                        MyStrings.totalWithdraw.tr,
                                        style: regularDefault.copyWith(color: MyColor.colorBlack.withOpacity(0.5), fontWeight: FontWeight.w500),
                                      ),
                                      Container(
                                        padding: const EdgeInsets.all(Dimensions.space8),
                                        alignment: Alignment.center,
                                        decoration: const BoxDecoration(color: MyColor.screenBgColor, shape: BoxShape.circle),
                                        child: const Icon(Icons.arrow_forward_rounded, color: MyColor.colorBlack, size: 15),
                                      )
                                    ],
                                  ),
                                  // const SizedBox(height: Dimensions.space8),
                                  Flexible(
                                    flex: 0,
                                    child: Text(
                                      controller.totalWithdraw,
                                      style: regularMediumLarge.copyWith(fontWeight: FontWeight.w600),
                                      overflow: TextOverflow.ellipsis,
                                      maxLines: 2,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                )),
          ],
        ),
      ),
    );
  }
}
